/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8260.DeviceView.BankLike;
import ibm.nways.jdm8260.DeviceView.BayLike;
import ibm.nways.jdm8260.DeviceView.BuilderLike;
import ibm.nways.jdm8260.DeviceView.DaughterCard;
import ibm.nways.jdm8260.DeviceView.DaughterCardLike;
import ibm.nways.jdm8260.DeviceView.DaughterCardView;
import ibm.nways.jdm8260.DeviceView.DaughterCardViewLike;
import ibm.nways.jdm8260.DeviceView.Factory;
import ibm.nways.jdm8260.DeviceView.FactoryLike;
import ibm.nways.jdm8260.DeviceView.Fan;
import ibm.nways.jdm8260.DeviceView.FanLike;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.HubLike;
import ibm.nways.jdm8260.DeviceView.HubUnknown;
import ibm.nways.jdm8260.DeviceView.ModuleLike;
import ibm.nways.jdm8260.DeviceView.NetworkSet;
import ibm.nways.jdm8260.DeviceView.NetworkSetLike;
import ibm.nways.jdm8260.DeviceView.NetworksWindowLike;
import ibm.nways.jdm8260.DeviceView.PortLike;
import ibm.nways.jdm8260.DeviceView.Power;
import ibm.nways.jdm8260.DeviceView.PowerLike;
import ibm.nways.jdm8260.DeviceView.Temperature;
import ibm.nways.jdm8260.DeviceView.TemperatureLike;
import ibm.nways.jdm8260.DeviceView.Trunk;
import ibm.nways.jdm8260.DeviceView.TrunkLike;
import ibm.nways.jdm8260.DeviceView.Tty;
import ibm.nways.jdm8260.DeviceView.TtyLike;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.io.Serializable;

public class Builder
implements BuilderLike {
    private static final Builder builderInstance = new Builder();
    private static FactoryLike factory = Factory.getInstance();

    private Builder() {
    }

    public static BuilderLike getInstance() {
        return builderInstance;
    }

    public HubLike buildHub(JdmBrowser jdmBrowser, MibInfo mibInfo) {
        Object object;
        String string = "buildHub";
        Serializable serializable = mibInfo.getVar("sysOid");
        int n = 0;
        try {
            object = (GenModel)jdmBrowser.getModel();
            GenModel genModel = (GenModel)object.getComponent("ConcScalars");
            Serializable serializable2 = genModel.getInfo("Panel").get("Panel.ConcType");
            if (serializable2 instanceof Integer) {
                n = (Integer)serializable2;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
        }
        if (!((object = factory.createHub(serializable, n)) instanceof HubUnknown)) {
            object.setCommonInformation(jdmBrowser, mibInfo);
            object.discoverChildren();
        }
        return object;
    }

    public ModuleLike buildModule(HubInfoLike hubInfoLike, int n, int n2, Serializable serializable, GraphicContainer graphicContainer, GenModel genModel) {
        String string = "." + n + "." + n2;
        MibInfo mibInfo = hubInfoLike.getMibInfo();
        Serializable serializable2 = mibInfo.getVar("ocModNumPorts", string);
        Serializable serializable3 = mibInfo.getVar("ocModNumOccupiedSlots", string);
        Serializable serializable4 = mibInfo.getVar("ocModNetwork", string);
        Serializable serializable5 = mibInfo.getVar("ocModSlotOffset", string);
        int n3 = (Integer)serializable;
        ModuleLike moduleLike = factory.createModule(mibInfo, n, n2, n3);
        int n4 = 1;
        if (serializable3 instanceof MibValue) {
            n4 = ((MibValue)serializable3).getIntValue();
        }
        int n5 = 1;
        if (serializable5 instanceof MibValue) {
            n5 = ((MibValue)serializable5).getIntValue();
        }
        int n6 = 0;
        if (serializable2 instanceof MibValue) {
            n6 = ((MibValue)serializable2).getIntValue();
        }
        Serializable serializable6 = mibInfo.getVar("ocModNumBridgePorts", string);
        int n7 = 0;
        if (serializable6 instanceof MibValue) {
            n7 = ((MibValue)serializable6).getIntValue();
        }
        moduleLike.setCommonInformation(hubInfoLike, n, n2, graphicContainer, n6, n7, n4, ((MibValue)serializable4).getIntValue(), n5, genModel);
        moduleLike.setSpecificInformation();
        moduleLike.discoverChildren();
        return moduleLike;
    }

    public PortLike buildPort(HubInfoLike hubInfoLike, String string, int n, int n2, int n3, int n4, int n5, int n6, GraphicContainer graphicContainer, String string2, GenModel genModel) {
        return this.internalBuildPort(hubInfoLike, string, n, n2, n3, 1, n4, n5, null, n6, graphicContainer, string2, genModel);
    }

    public PortLike buildPort(HubInfoLike hubInfoLike, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, GraphicContainer graphicContainer, String string2, GenModel genModel) {
        return this.internalBuildPort(hubInfoLike, string, n, n2, n3, n4, n5, n6, null, n7, graphicContainer, string2, genModel);
    }

    public PortLike buildPort(HubInfoLike hubInfoLike, String string, int n, int n2, int n3, int n4, int n5, String string2, int n6, GraphicContainer graphicContainer, String string3, GenModel genModel) {
        return this.internalBuildPort(hubInfoLike, string, n, n2, n3, 1, n4, n5, string2, n6, graphicContainer, string3, genModel);
    }

    public TtyLike buildTty(HubInfoLike hubInfoLike, String string, int n, int n2, int n3, String string2, GraphicContainer graphicContainer) {
        Tty tty = new Tty();
        tty.setCommonInformation(hubInfoLike, string, n, n2, n3, string2, graphicContainer);
        return tty;
    }

    public FanLike buildFan(HubInfoLike hubInfoLike, int n, Point point, GraphicContainer graphicContainer) {
        Fan fan = new Fan();
        fan.setCommonInformation(hubInfoLike, n, point, graphicContainer);
        return fan;
    }

    public PowerLike buildPower(HubInfoLike hubInfoLike, int n, Point point, GraphicContainer graphicContainer) {
        Power power = new Power();
        power.setCommonInformation(hubInfoLike, n, point, graphicContainer);
        return power;
    }

    public TemperatureLike buildTemperature(HubInfoLike hubInfoLike, Point point, GraphicContainer graphicContainer) {
        Temperature temperature = new Temperature();
        temperature.setCommonInformation(hubInfoLike, point, graphicContainer);
        return temperature;
    }

    public BayLike buildBay(HubInfoLike hubInfoLike, int n, int n2, int n3, Serializable serializable, int n4, int n5, Point point, GraphicContainer graphicContainer, String string, GenModel genModel) {
        return this.buildBay(hubInfoLike, n, n2, n3, serializable, 0, n4, n5, point, graphicContainer, string, genModel);
    }

    public BayLike buildBay(HubInfoLike hubInfoLike, int n, int n2, int n3, Serializable serializable, int n4, int n5, int n6, Point point, GraphicContainer graphicContainer, String string, GenModel genModel) {
        BayLike bayLike = factory.createBay(n, n2, (Integer)serializable);
        bayLike.setCommonInformation(hubInfoLike, n, n2, n3, n4, point, graphicContainer, n5, n6, string, genModel);
        bayLike.setSpecificInformation();
        bayLike.discoverChildren();
        return bayLike;
    }

    public NetworksWindowLike buildNetworks(HubInfoLike hubInfoLike, Point point, GraphicContainer graphicContainer) {
        NetworksWindowLike networksWindowLike = hubInfoLike.getNetworksWindow();
        networksWindowLike.setCommonInformation(hubInfoLike, point, graphicContainer);
        networksWindowLike.discoverChildren();
        return networksWindowLike;
    }

    public NetworkSetLike buildNetworkSet(HubInfoLike hubInfoLike, Point point, GraphicContainer graphicContainer, String string, String string2) {
        NetworkSet networkSet = new NetworkSet();
        networkSet.setCommonInformation(hubInfoLike, point, graphicContainer, string, string2);
        return networkSet;
    }

    public BankLike buildBank(HubInfoLike hubInfoLike, int n, int n2, int n3, int n4, int n5, int n6, Point point, GraphicContainer graphicContainer, String string, GenModel genModel) {
        BankLike bankLike = factory.createBank(n5, n4);
        bankLike.setCommonInformation(hubInfoLike, n, n2, n3, point, graphicContainer, n5, n6, string, genModel);
        bankLike.discoverChildren();
        return bankLike;
    }

    public DaughterCardViewLike buildDaughterCardView(HubInfoLike hubInfoLike, int n, Point point, GraphicContainer graphicContainer) {
        DaughterCardView daughterCardView = new DaughterCardView();
        daughterCardView.setCommonInformation(hubInfoLike, n, point, graphicContainer);
        daughterCardView.discoverChildren();
        return daughterCardView;
    }

    public DaughterCardLike buildDaughterCard(HubInfoLike hubInfoLike, int n, int n2, int n3, Point point, GraphicContainer graphicContainer) {
        DaughterCard daughterCard = new DaughterCard();
        daughterCard.setCommonInformation(hubInfoLike, n, n2, n3, point, graphicContainer);
        return daughterCard;
    }

    public TrunkLike buildTrunk(HubInfoLike hubInfoLike, String string, int n, int n2, int n3, int n4, GraphicContainer graphicContainer, String string2, GenModel genModel) {
        String string3 = "." + n + "." + n2;
        Trunk trunk = new Trunk();
        MibInfo mibInfo = hubInfoLike.getMibInfo();
        Serializable serializable = mibInfo.getVar("trunkType", string3);
        int n5 = 1;
        if (serializable instanceof MibValue) {
            n5 = ((MibValue)serializable).getIntValue();
        }
        serializable = mibInfo.getVar("trunkNetwork", string3);
        int n6 = 4;
        if (serializable instanceof MibValue) {
            n6 = ((MibValue)serializable).getIntValue();
        }
        trunk.setCommonInformation(hubInfoLike, string, n, n2, n4, n5, n3, n6, graphicContainer, string2, genModel);
        return trunk;
    }

    private PortLike internalBuildPort(HubInfoLike hubInfoLike, String string, int n, int n2, int n3, int n4, int n5, int n6, String string2, int n7, GraphicContainer graphicContainer, String string3, GenModel genModel) {
        String string4 = "internalBuildPort";
        PortLike portLike = null;
        try {
            portLike = factory.createPort(n7, n4, string2);
            portLike.setCommonInformation(hubInfoLike, string, n, n2, n3, n5, n6, n7, graphicContainer, string3, genModel);
            portLike.setSpecificInformation();
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string4, exception);
        }
        return portLike;
    }
}

